#include "../generator.h"
#include "../bdtypes.h"
#include "../bdfunc.h"
#include "../bdglobal.h"
#include "../scorpion.h"

static DWORD dwId[] = {kenny1, kenny2, kenny3, kenny4, kenny5, kenny6, kenny7, kenny8, kenny9, kenny10};
#define NB_KENNYS (sizeof(dwId)/sizeof(DWORD))
static Obj3d Kenny[NB_KENNYS];
static float Matrix[16], Matrix2[16];

static float *sow, *tow;
static DWORD *A, *B, *C;

void LInit_Kenny()
{
	DWORD Cpt1, Cpt2;
	DWORD dwDummy;
	FILE *file;
	DWORD dwNbVertices, dwNbFaces;
	DWORD dwTmp;

	for(Cpt1=0;Cpt1<NB_KENNYS;Cpt1++)
	{
		LoadObject(&Kenny[Cpt1], dwId[Cpt1], kennyface);
	}

	PrepareTextureFromArray(g_PicKenny, 256, 256, &g_TextureKenny);

	file = fopen(PackageName, "rb");
	SeekToSubfile(file, kennymap, &dwDummy);

	fread(&dwNbVertices, 4, 1, file);
	fread(&dwNbFaces, 4, 1, file);

	sow = (float*)malloc(dwNbVertices*sizeof(float));
	tow = (float*)malloc(dwNbVertices*sizeof(float));
	A = (DWORD*)malloc(dwNbFaces*sizeof(DWORD));
	B = (DWORD*)malloc(dwNbFaces*sizeof(DWORD));
	C = (DWORD*)malloc(dwNbFaces*sizeof(DWORD));

	for(Cpt1=0;Cpt1<dwNbVertices;Cpt1++)
	{
		fread(sow+Cpt1, 4, 1, file);
		fread(tow+Cpt1, 4, 1, file);
	}

	for(Cpt1=0;Cpt1<dwNbFaces;Cpt1++)
	{
		fread(A+Cpt1, 4, 1, file);
		fread(B+Cpt1, 4, 1, file);
		fread(C+Cpt1, 4, 1, file);
	}

	for(Cpt2=0;Cpt2<NB_KENNYS;Cpt2++)
	for(Cpt1=0;Cpt1<dwNbFaces;Cpt1++)
	{
		Kenny[Cpt2].pFace[Cpt1].SowA = sow[C[Cpt1]];
		Kenny[Cpt2].pFace[Cpt1].TowA = tow[C[Cpt1]];
		Kenny[Cpt2].pFace[Cpt1].SowB = sow[B[Cpt1]];
		Kenny[Cpt2].pFace[Cpt1].TowB = tow[B[Cpt1]];
		Kenny[Cpt2].pFace[Cpt1].SowC = sow[A[Cpt1]];
		Kenny[Cpt2].pFace[Cpt1].TowC = tow[A[Cpt1]];
	}

	fclose(file);

}

void QInit_Kenny()
{
	grDepthBufferMode(GR_DEPTHBUFFER_WBUFFER);
	grDepthBufferFunction(GR_CMP_LESS);
	grAlphaCombine(GR_COMBINE_FUNCTION_LOCAL, GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_FACTOR_NONE, GR_COMBINE_OTHER_NONE, FXFALSE);
	grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ZERO,
							GR_BLEND_ONE, GR_BLEND_ZERO);
	grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
					GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_ITERATED, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
	grConstantColorValue(0xffffff);

	grAlphaTestFunction(GR_CMP_ALWAYS);
	grChromakeyMode(GR_CHROMAKEY_DISABLE);
	grCullMode(GR_CULL_DISABLE);
	grFogMode(GR_FOG_DISABLE);

	DownloadTexture(&g_TextureKenny);
	SelectTexture(g_TextureKenny);
}

void Effect_Kenny()
{
	BeIdentityMatrix(Matrix);
	RotateZMatrix(Matrix2, Matrix, -2048);
	RotateXMatrix(Matrix, Matrix2, 2048);
	TranslateMatrix(Matrix, 0, 0, 100.f);
	DrawWithMatrix(&Kenny[(g_demostate.TickInEffect/256)%NB_KENNYS], Matrix, 0, 0, 1);

}

void ByeBye_Kenny()
{
	FreeTexture(&g_TextureKenny);
}